/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.helper;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import tschipp.carryon.common.helper.InvalidConfigException;

public class StringParser {
    @Nullable
    public static Block getBlock(String string) {
        Block block;
        if (string == null) {
            return null;
        }
        NBTTagCompound tag = StringParser.getTagCompound(string);
        if (tag != null) {
            string = string.replace(tag.toString(), "");
        }
        if (string.contains(";")) {
            string = string.replace(string.substring(string.indexOf(";")), "");
        }
        if ((block = Block.func_149684_b((String)string)) == null) {
            new InvalidConfigException("Block Parsing Error. Invalid Name: " + string).printException();
        }
        return block;
    }

    public static int getMeta(String string) {
        if (string == null) {
            return 0;
        }
        NBTTagCompound tag = StringParser.getTagCompound(string);
        if (tag != null) {
            string = string.replace(tag.toString(), "");
        }
        if (string.contains(";")) {
            int meta = 0;
            try {
                meta = Integer.parseInt(string.substring(string.indexOf(";")).replace(";", ""));
            }
            catch (Exception e) {
                new InvalidConfigException("Meta Parsing Error at: " + string + " : " + e.getMessage()).printException();
            }
            return meta;
        }
        return 0;
    }

    @Nullable
    public static IBlockState getBlockState(String string) {
        Block block;
        int meta;
        if (string == null) {
            return null;
        }
        NBTTagCompound tag = StringParser.getTagCompound(string);
        if (tag != null) {
            string = string.replace(tag.toString(), "");
        }
        if ((meta = StringParser.getMeta(string)) == 0 && (block = StringParser.getBlock(string)) != null) {
            return block.func_176223_P();
        }
        try {
            return StringParser.getBlock(string).func_176203_a(meta);
        }
        catch (Exception e) {
            new InvalidConfigException("Blockstate parsing Exception at: " + string + " : " + e.getMessage()).printException();
            return null;
        }
    }

    @Nullable
    public static Item getItem(String string) {
        if (string == null) {
            return null;
        }
        NBTTagCompound tag = StringParser.getTagCompound(string);
        if (tag != null) {
            string = string.replace(tag.toString(), "");
        }
        if (string.contains(";")) {
            string = string.replace(string.substring(string.indexOf(";")), "");
        }
        return Item.func_111206_d((String)string);
    }

    public static ItemStack getItemStack(String string) {
        if (string == null) {
            return null;
        }
        Item item = StringParser.getItem(string);
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack(item, 1, StringParser.getMeta(string));
        NBTTagCompound tag = StringParser.getTagCompound(string);
        if (tag != null) {
            stack.func_77982_d(tag);
        }
        return stack;
    }

    @Nullable
    public static NBTTagCompound getTagCompound(String string) {
        NBTTagCompound tag = null;
        if (string == null) {
            return null;
        }
        if (string.contains("{")) {
            if (!string.contains("}")) {
                new InvalidConfigException("Missing } at  : " + string).printException();
            }
            String nbt = string.substring(string.indexOf("{"));
            string = string.replace(nbt, "");
            try {
                tag = JsonToNBT.func_180713_a((String)nbt);
            }
            catch (NBTException e) {
                new InvalidConfigException("Error while parsing NBT: " + e.getMessage()).printException();
                return null;
            }
        } else if (string.contains("}")) {
            new InvalidConfigException("Missing { at  : " + string).printException();
        }
        return tag;
    }
}

